% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{lilliefors}
\alias{lilliefors}
\title{Lilliefors (Kolmogorov-Smirnov) test for normality}
\usage{
lilliefors(x)
}
\arguments{
\item{x}{A numeric vector of data values, the number of observations must be greater than 4.
Missing values are allowed.}
}
\description{
Performs the Lilliefors (Kolmogorov-Smirnov) test for the composite hypothesis of normality. The Lilliefors (Kolomorov-Smirnov) test is the most famous EDF omnibus test for normality; compared to the Anderson-Darling test and the Cramer-von Mises test it is known to perform worse.
}
\examples{
set.seed(1234)
x = rnorm(1000)
lilliefors(x)
}
\references{
Thode Jr., H.C. (2002): Testing for Normality. Marcel Dekker, New York.
}

