% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{as.timedf}
\alias{as.timedf}
\title{A data.frame with time series parameters}
\usage{
as.timedf(timevar, format, x = NULL, tz = "GMT")
}
\arguments{
\item{timevar}{the time variable}

\item{format}{the time format}

\item{x}{the data variable to be converted to a time series}

\item{tz}{Time zone code, default is \dQuote{GMT}}
}
\description{
Return a \code{data.frame} with time parameters and time variable
}
\details{
A data frame containing time variable parameters and measuring variable
}
\examples{
data(ssex)
myts <- as.timedf(timevar = ssex$Date, format = "\%Y", x= ssex$Favor)
peek(myts)

data(us2012)
Obama.ts <- as.timedf(us2012[,3], "\%Y-\%m-\%d", us2012[,8])
peek(Obama.ts)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\seealso{
\link{tsCollapse}
}
\keyword{Data-Manipulation}

