#' write_circos_links
#'
#' @author Matthew Woodruff, Emory University
#'
#' @description A function that takes a data frame in the format of those returned by the `make_circos_links` function, and writes a "links"
#' file for Circos plotting
#'
#' @param df A data frame in the format of those returned by the `make_circos_links` function
#' @param file_name The desired file name. Defaults to links.txt in the current working directory
#' @param include_colors Include colors generated by the `color_circos_links` function in the write file
#' @param file_path The desired file path destination folder. Defaults to NULL
#'
#' @return Writes a Circos-compatible links file to the desired directory
#'
#' @export
#'
#' @import readr
#' @import dplyr
#'
#' @examples
#'
#' df <- data.frame(lin_id = c(1,2), chr1 = c(1,1), band1 = c(1,1),
#' chr1_start = c(1,5), chr1_end = c(5,8),
#' n1 = c(5,3), chr2 = c(1,2), band2 = c(2,1),
#' chr2_start = c(8,1), chr2_end = c(13,5), n2 = c(5,5))
#'
#' write_circos_links(df = df, file_name = "links.txt", file_path = tempdir())

write_circos_links <- function(df, include_colors = FALSE, file_name = "links.txt", file_path = NULL) {

  if (is.null(file_path)) {

    stop("write_circos_links() requires a file_path (destination folder)")

  }

  if (include_colors == TRUE) {

    df <- select(df, 2, 4, 5, 7, 9, 10, 12) # converts to circos syntax with colors

  } else {

    df <- select(df, 2, 4, 5, 7, 9, 10) # converts to circos syntax

  }

  file_dir <- file.path(file_path, file_name)

  write_delim(df, path = file_dir, delim = " ", col_names = FALSE)

}

