% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILO.R
\name{SILOQualityCodes}
\alias{SILOQualityCodes}
\title{Plot the quality codes of the SILO rainfall data}
\usage{
SILOQualityCodes(SILO, filename = NULL)
}
\arguments{
\item{SILO}{a list of sites with SILO data, as created by SILOLoad()}

\item{filename}{optional, filename to save a plot of the rainfall quality codes to, including extension (e.g. .png). Filename can include full path or sub folders.}
}
\value{
a ggplot geom_tile plot of the rainfall quality codes
}
\description{
Plot the quality codes of the SILO rainfall data
}
\examples{
\dontrun{
X<-SILOLoad(c("24001","24002","24003"),path="./SWTools/extdata")
p<-SILOQualityCodes(X)
}

}
