% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_summary.R
\name{threshold_summary}
\alias{threshold_summary}
\alias{threshold_summary.swmpr}
\title{Summary Plots for Threshold Identification}
\usage{
threshold_summary(swmpr_in, ...)

\method{threshold_summary}{swmpr}(
  swmpr_in,
  param = NULL,
  summary_type = c("month", "season", "year"),
  parameter_threshold = NULL,
  threshold_type = NULL,
  time_threshold = NULL,
  converted = FALSE,
  pal = "Set3",
  plot_title = FALSE,
  plot = TRUE,
  label_y_axis = TRUE,
  ...
)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods. See \code{\link{assign_season}} for more details.}

\item{param}{chr string of variable to plot (one only)}

\item{summary_type}{Choose from \code{month}, \code{season}, or \code{year} aggregation}

\item{parameter_threshold}{vector of numerical thresholds to evaluate parameters against}

\item{threshold_type}{vector of logical operators ('<', '>', '<=', '>=', '==', '!=')}

\item{time_threshold}{The amount of time an event must last to be counted (in hours)}

\item{converted}{logical, were the units converted from the original units used by CDMO? Defaults to \code{FALSE}. See \code{y_labeler} for details.}

\item{pal}{Select a palette for boxplot fill colors. See \code{\link[ggplot2]{scale_fill_brewer}} for more details.}

\item{plot_title}{logical, should the station name be included as the plot title? Defaults to \code{FALSE}}

\item{plot}{logical, should a plot be returned? Defaults to \code{TRUE}}

\item{label_y_axis}{logical, include label for y-axis?}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object (if \code{plot} = \code{TRUE}) or a dataframe (if \code{plot} = \code{FALSE})
}
\description{
Summary plots for threshold identification analysis
}
\details{
This function provides a graphical or tabular summary of the results from \code{threshold_identification}. The user can summarize results on a monthly, seasonal, or annual basis by specifying \code{summary_type = c('month', 'season', 'year')}. If \code{summary_type = 'season'}, then the user should also define \code{season}, \code{season_names}, and \code{season_start}, as required by |code{\link{assign_season}}. The user can specify \code{'month'} for nutrient parameters, but this is not recommended and will produce a warning.

Recommended thresholds for chlorophyll-a, dissolved inorganic nitrogen, dissolved inorganic phosphorus, and dissolved oxygen can be found in the National Coastal Condition Assessment 2010 (USEPA 2016)
}
\examples{
## Water quality examples
data(apacpwq)
dat_wq <- qaqc(apacpwq, qaqc_keep = c(0, 3, 5))
dat_wq <- SWMPr::setstep(dat_wq)

x <-
  threshold_summary(dat_wq, param = 'do_mgl', parameter_threshold = 2
  , threshold_type = '<', time_threshold = 2, summary_type = 'month'
  , plot_title = TRUE)

\donttest{
y <-
  threshold_summary(dat_wq, param = 'do_mgl', parameter_threshold = 2,
  threshold_type = '<', time_threshold = 2, summary_type = 'season',
  season_grps = list(c(1,2,3), c(4,5,6), c(7,8,9), c(10, 11, 12)),
  season_names = c('Winter', 'Spring', 'Summer', 'Fall'),
  season_start = 'Winter',
  plot_title = TRUE)

## Nutrient examples
dat_nut <- qaqc(apacpnut, qaqc_keep = c(0, 3, 5))

x <-
  threshold_summary(dat_nut, param = 'chla_n',
  parameter_threshold = 10,
  threshold_type = '>', summary_type = 'month',
  plot_title = TRUE)

y <-
  threshold_summary(dat_nut, param = 'chla_n', parameter_threshold = 10,
  threshold_type = '>', summary_type = 'season',
  season_grps = list(c(1,2,3), c(4,5,6), c(7,8,9), c(10, 11, 12)),
  season_names = c('Winter', 'Spring', 'Summer', 'Fall'),
  season_start = 'Winter', plot_title = TRUE)

 z <-
   threshold_summary(dat_nut, param = 'chla_n', parameter_threshold = 10,
   threshold_type = '>', summary_type = 'year',
   plot_title = TRUE, plot = TRUE)
}
}
\references{
United States Environmental Protection Agency (USEPA). 2015. "National Coastal Condition Assessment 2010". EPA 841-R-15-006.
https://cfpub.epa.gov/si/si_public_record_Report.cfm?Lab=OWOW&dirEntryId=327030
}
\seealso{
\code{\link{assign_season}}, \code{\link[ggplot2]{ggplot}}, \code{\link{threshold_identification}}, \code{\link[ggplot2]{scale_fill_brewer}}
}
\author{
Julie Padilla
}
\concept{analyze}
