% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_simData.R
\name{plot_simData}
\alias{plot_simData}
\title{Visualizing the simulated data using heatmap or 3D surface plot}
\usage{
plot_simData(sim_object, data = "merged", type = "heatmap")
}
\arguments{
\item{sim_object}{R object containing simulated data as returned by \code{OmixCraftHD}.}

\item{data}{Character. Specifies which data matrix to visualize. Options are "merged" (or "concatenated"), "omic.one", or "omic.two".}

\item{type}{Character. Type of plot: either "heatmap" for a 2D image plot or "3D" for a 3D perspective surface plot.}
}
\description{
Generates a visual representation of the simulated omics data either as a heatmap or a 3D surface plot. You can select which dataset to visualize: the merged/concatenated matrix, omic one, or omic two.
}
\examples{
output_obj <- OmixCraftHD(
  vector_features = c(4000,3000),
  n_samples=100,
  n_factors=2,
  signal.samples = NULL,
  signal.features.one = NULL,
  signal.features.two = NULL,
  snr = 2.5,
  num.factor='multiple',
  advanced_dist='mixed')

plot_simData(sim_object = output_obj, data = "merged", type = "heatmap")
plot_simData(sim_object = output_obj, data = "omic.one", type = "3D")
}
