% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projKenya.R
\name{projKenya}
\alias{projKenya}
\title{Map projection for Kenya}
\usage{
projKenya(lon, lat = NULL, inverse = FALSE)
}
\arguments{
\item{lon}{either longitude or, if inverse == TRUE, easting in km}

\item{lat}{either latitude or, if inverse == TRUE, northing in km}

\item{inverse}{if FALSE, projects from lon/lat to easting/northing.  Else from easting/northing to lon/lat}
}
\value{
A 2 column matrix of easting/northing coordinates in km if inverse == FALSE. Otherwise, a 2 column matrix of longitude/latitude coordinates.
}
\description{
Projection specifically chosen for Kenya. Project from lat/lon to northing/easting 
in kilometers.  Uses epsg=21097 with km units. May not work on all systems due to 
differences in the behavior between different PROJ and GDAL versions.
}
\examples{
eastLim = c(-110.6405, 832.4544)
northLim = c(-555.1739, 608.7130)
coordMatrixEN = cbind(eastLim, northLim)
coordMatrixLL = projKenya(coordMatrixEN, inverse=TRUE)

coordMatrixLL
# if the coordMatrixLL isn't the following, projKenya may not support 
# your installation of GDAL and/or PROJ:
#      east north
# [1,] 33.5  -5.0
# [2,] 42.0   5.5

projKenya(coordMatrixLL, inverse=FALSE)
# regardless of your PROJ/GDAL installations, the result of the 
# above line of could should be:
#            lon       lat
# [1,] -110.6405 -555.1739
# [2,]  832.4544  608.7130

}
\author{
John Paige
}
