% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popGrid.R
\name{calibrateByRegion}
\alias{calibrateByRegion}
\title{Calibrate the point level totals so their sum matches the regional totals}
\usage{
calibrateByRegion(pointTotals, pointRegions, regions, regionTotals)
}
\arguments{
\item{pointTotals}{Vector of point level totals that will be calibrated/normalized}

\item{pointRegions}{Vector of regions associated with each point}

\item{regions}{Vector of region names}

\item{regionTotals}{Vector of desired region level totals associated with `regions`}
}
\value{
A vector of same length as pointTotals and pointRegions containing 
the calibrated/normalized point totals that sum to the correct regional totals

Vector of updated point level totals, calibrated to match region totals
}
\description{
Calibrate/normalize the point level totals so their sum matches the 
regional totals. Technically, the totals can be at any level smaller  
than the region level specified.
}
\examples{
pointTotals = c(1, 1, 1, 2)
pointRegions = c("a", "a", "b", "b")
regionTotals = c(10, 20)
regions = c("a", "b")
calibrateByRegion(pointTotals, pointRegions, regions, regionTotals)

}
\author{
John Paige
}
