% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SUMMERmodel}
\alias{summary.SUMMERmodel}
\title{Summary method for the smoothing models.}
\usage{
\method{summary}{SUMMERmodel}(object, ...)
}
\arguments{
\item{object}{output from \code{\link{smoothDirect}} or \code{\link{smoothCluster}}}

\item{...}{not used}
}
\description{
This function is the summary method for class \code{SUMMERmodel}.
}
\examples{
\dontrun{
  library(SUMMER)
  library(dplyr)
  data(DemoData)

  # Smooth Direct Model
  years <- levels(DemoData[[1]]$time)
  # obtain direct estimates
  data_multi <- getDirectList(births = DemoData, years = years,
  regionVar = "region",  timeVar = "time", clusterVar = "~clustid+id",
  ageVar = "age", weightsVar = "weights", geo.recode = NULL)
  data <- aggregateSurvey(data_multi)
  
  years.all <- c(years, "15-19")
  fit <- smoothDirect(data = data, Amat = NULL, 
  year_label = years.all, year_range = c(1985, 2019), 
  time.model = 'rw2', is.yearly=FALSE, m = 5)
  summary(fit)

  # Cluster-level Model
  counts.all <- NULL
  for(i in 1:length(DemoData)){
  counts <- getCounts(DemoData[[i]][, c("clustid", "time", "age", "died",
                                       "region", "strata")],
           variables = 'died', by = c("age", "clustid", "region", 
                                        "time", "strata"))
  counts <- counts \%>\% mutate(cluster = clustid, years = time, Y=died)
  counts$strata <- gsub(".*\\\\.","",counts$strata)
  counts$survey <- names(DemoData)[i] 
  counts.all <- rbind(counts.all, counts)
  }
  
  # fit cluster-level model on the periods
  periods <- levels(DemoData[[1]]$time)
  fit <- smoothCluster(data = counts.all, 
     Amat = DemoMap$Amat, 
     time.model = "rw2", 
     st.time.model = "rw1",
     strata.time.effect =  TRUE, 
     survey.effect = TRUE,
     family = "betabinomial",
     year_label = c(periods, "15-19"))
  summary(fit) 
}
}
\seealso{
\code{\link{summary.SUMMERmodel}}
}
\author{
Zehang Li
}
