% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangeRegion.R
\name{ChangeRegion}
\alias{ChangeRegion}
\title{Function to map region names to a common set.}
\usage{
ChangeRegion(data, Bmat, regionVar = "region")
}
\arguments{
\item{data}{Pre-processed data}

\item{Bmat}{Matrix of changes. Each row corresponds to a region name possibly in the data files, and each column corresponds to a region after mapping. The values in the matrix are binary. The row names and column names need to be specified to the region names.}

\item{regionVar}{String indicating the region variable. Defaults to 'region'.}
}
\value{
Data after changing region names
}
\description{
Function to map region names to a common set.
}
\examples{

# Construct a small test data
testdata <- data.frame(region = c("north", "south", "east",
 "south", "east"), index = c(1:5))

# Construct a changing rule: combining south and east
Bmat <- matrix(c(1, 0, 0, 0, 1, 1), 3, 2)
colnames(Bmat) <- c("north", "south and east")
rownames(Bmat) <- c("north", "south", "east")
print(Bmat)

# New data after transformation
test <- ChangeRegion(testdata, Bmat, "region")
print(test)
}
