% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max-perc-1RM.R
\name{max_perc_1RM}
\alias{max_perc_1RM}
\alias{max_perc_1RM_epley}
\alias{max_perc_1RM_modified_epley}
\alias{max_perc_1RM_linear}
\title{Family of functions to estimate max \%1RM}
\usage{
max_perc_1RM_epley(reps, k = 0.0333)

max_perc_1RM_modified_epley(reps, kmod = 0.0353)

max_perc_1RM_linear(reps, klin = 33)
}
\arguments{
\item{reps}{Numeric vector. Number of repetition to be performed}

\item{k}{User defined \code{k} parameter in the Epley's equation. Default is 0.0333}

\item{kmod}{User defined \code{kmod} parameter in the Modified Epley's equation. Default is 0.0353}

\item{klin}{User defined \code{klin} parameter in the Linear equation. Default is 33}
}
\value{
Numeric vector. Predicted \%1RM
}
\description{
Family of functions to estimate max \%1RM
}
\section{Functions}{
\itemize{
\item \code{max_perc_1RM_epley}: Estimate max \%1RM using the Epley's equation

\item \code{max_perc_1RM_modified_epley}: Estimate max \%1RM using the Modified Epley's equation

\item \code{max_perc_1RM_linear}: Estimate max \%1RM using the Linear (or Brzycki's) equation
}}

\examples{
# ------------------------------------------
# Epley equation
max_perc_1RM_epley(1:10)
max_perc_1RM_epley(1:10, k = 0.04)
# ------------------------------------------
# Modified Epley equation
max_perc_1RM_modified_epley(1:10)
max_perc_1RM_modified_epley(1:10, kmod = 0.05)
# ------------------------------------------
# Linear/Brzycki equation
max_perc_1RM_linear(1:10)
max_perc_1RM_linear(1:10, klin = 36)
}
