% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunction.R
\name{SearchSTMotifs}
\alias{SearchSTMotifs}
\title{SearchSTMotifs}
\usage{
SearchSTMotifs(D, DS, w, a, sb, tb, si = 3, ka = 3)
}
\arguments{
\item{D}{Dataset containing numeric values}

\item{DS}{Dataset containing SAX encoded values}

\item{w}{Word Size}

\item{a}{Number of letters to do the encode}

\item{sb}{"Space slice" Number of columns in each block}

\item{tb}{"Time slice" Number of rows in each block}

\item{si}{Support of Global Occurrence (GO)}

\item{ka}{Support for Spatial Occurrence (SO)}
}
\value{
Return a list of identified motifs. Each motif contains the information [isaxcode, recmatrix, vectst], as described:

isaxcode: Motif sequences in character format

recmatrix: Matrix giving as information the blocks containing this motif

vectst: Coordinate of the start positions of the motif in the original dataset
}
\description{
Search for Spatial-time Motifs
}
\examples{
#Search for Spatial-time Motifs
D  <- STMotif::example_dataset
DS <- NormSAX(STMotif::example_dataset,5)
stmotifs <- SearchSTMotifs(D,DS,4,5,4,10,2,2)
}
