% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_threshold.R
\name{test_threshold}
\alias{test_threshold}
\title{test_threshold.R}
\usage{
test_threshold(stic_data, calibration)
}
\arguments{
\item{stic_data}{classified STIC data frame with the variable names of that produced by \link{classify_wetdry}}

\item{calibration}{the model object used to calibrate SpC, generated by the \link{get_calibration} function and used in \link{apply_calibration}}
}
\value{
A time series plot of classified wet/dry observations through time using three different absolute classification thresholds: the y-intercept of the fitted model developed in get_calibration, the y-intercept plus one standard error, and the y-intercept minus one standard error
}
\description{
This function is intended to allow the user to visually assess the effects of classification threshold uncertainty on STIC classification. It takes the the model object used to calibrate SpC, as well as a classified STIC data frame with column names matching those produced by \link{classify_wetdry}.
}
\examples{
lm_calibration <- get_calibration(calibration_standard_data)
threshold_testing_plot <- test_threshold(stic_data = classified_df, calibration = lm_calibration)

}
