% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSL.R
\name{sslLDS}
\alias{sslLDS}
\title{Low Density Separation}
\usage{
sslLDS(xl, yl, xu, rho = 1, C = 1, dist.type = "Euclidean", p = 0.3,
  improvement = 1e-04, seed = 0, delta = 0.01, alpha = 0.01)
}
\arguments{
\item{xl}{a n * p matrix or data.frame of labeled data}

\item{yl}{a n * 1 binary labels(1 or -1).}

\item{xu}{a m * p matrix or data.frame of unlabeled data.}

\item{rho}{numeric;a parameter for connectivity kernel.It defines  minimal rho-path distances.}

\item{C}{numeric; a parameter in the TSVM training model.}

\item{dist.type}{character string; this parameter controls the type of distance measurement.(see \code{\link{dist}} or \code{\link{pr_DB}}).}

\item{p}{the percentage of data used for cross-validation set.}

\item{improvement}{numeric; minimal allowed improvement of parameters.}

\item{seed}{an integer specifying random number generation state for spliting labeled data into training set and cross-validation set.}

\item{delta}{numeric; a allowed cutoff for the cumulative percent of variance to lose by multidimensional scaling.}

\item{alpha}{numeric; a learning rate in the gradient descent algorithm.}
}
\value{
a list of values is returned:
}
\description{
\code{sslLDS} implements low density separation with Transductive Support Vector Machines(TSVM) for semi-supervised binary classification
}
\details{
\code{sslLDS} constructs a low density graph with connectivity kernel.It implements multidemensional scaling
for demensionality reduction and chooses optimal \code{C.star} by cross-validation. Finally, it trains the TSVM model with gradient descent algorithm.
}
\section{Fields}{

\describe{
\item{\code{yu}}{the predicted label of unlabeled data}

\item{\code{optC.star}}{the optimal C.star chosen by cross-validation. C.star weights the unlabeled data in the TSVM model.}

\item{\code{para}}{estimated parameters of TSVM, including \code{w} and \code{b}}
}}
\examples{
data(iris)
xl<-iris[c(1:20,51:70),-5]
xu<-iris[c(21:50,71:100),-5]
yl<-rep(c(1,-1),each=20)
l<-sslLDS(xl,yl,xu,alpha=0.1)
}
\author{
Junxiang Wang
}
\references{
Chapelle, O., & Zien, A. (2005) Semi-supervised classification by low density separation.In Proceedings of the tenth international workshop on artificial intelligence and statistics.(pp. 57-64). Barbados.
}

