% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SortRows.R
\name{SortRows}
\alias{SortRows}
\title{Sorting rows of a matrix or data frame}
\usage{
SortRows(m, cols = 1:dim(m)[2], index.return = FALSE)
}
\arguments{
\item{m}{matrix or data frame}

\item{cols}{Indexes of columns, in the desired order, used for sorting.}

\item{index.return}{logical indicating if the ordering index vector should be
returned instead of sorted input.}
}
\value{
sorted \code{m} or a row index vector
}
\description{
Sorting rows of a matrix or data frame
}
\examples{
d <- SSBtoolsData("d2w")
SortRows(d[4:7])
SortRows(d, cols = 4:7)
SortRows(d, cols = c(2, 4))

SortRows(matrix(sample(1:3,15,TRUE),5,3))
}
\author{
Øyvind Langsrud
}
