% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussIterationFunction.R
\name{GaussIterationFunction}
\alias{GaussIterationFunction}
\title{An \code{iFunction} argument to \code{\link{GaussSuppression}}}
\usage{
GaussIterationFunction(i, I, j, J, true, false, na, filename = NULL, ...)
}
\arguments{
\item{i}{Number of candidates processed (columns of \code{x})}

\item{I}{Total number of candidates to be processed (columns of \code{x})}

\item{j}{Number of eliminated dimensions (rows of \code{x})}

\item{J}{Total number of dimensions (rows of \code{x})}

\item{true}{Candidates decided to be suppressed}

\item{false}{Candidates decided to be not suppressed}

\item{na}{Candidates not decided}

\item{filename}{When non-NULL, the above arguments will be saved to this file.
Note that \code{GaussSuppression} passes this parameter via \code{...}.}

\item{...}{Extra parameters}
}
\value{
\code{NULL}
}
\description{
Use this function as \code{iFunction} or write your own using the same seven first parameters and also using \code{...}.
}
\details{
The number of candidates decided (\code{true} and \code{false}) may differ from the number of candidates processed (\code{i}) due to parameter \code{removeDuplicated}
and because the decision for some unprocessed candidates can be found due to empty columns.
}
