% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stack.R
\name{Unstack}
\alias{Unstack}
\title{Unstack a column from a data frame and include additional variables.}
\usage{
Unstack(data, mainVar = 1, stackVar = (1:NCOL(data))[-mainVar],
  extraVar = integer(0), blockVar = integer(0), sep = "_",
  returnRowData = TRUE, sorted = FALSE)
}
\arguments{
\item{data}{A data frame}

\item{mainVar}{Index of the variable to be unstacked}

\item{stackVar}{Index of variables defining the unstack grouping}

\item{extraVar}{Indices of within-replicated variables to be added to the rowData output}

\item{blockVar}{Indices of between-replicated variables to be added to the data output}

\item{sep}{A character string to separate when creating variable names}

\item{returnRowData}{When FALSE output is no list, but only data}

\item{sorted}{When TRUE the created variables is in sorted order. Otherwise input order is used.}
}
\value{
When returnRowData=TRUE output is list of two elements.
\item{data}{Unstacked data}
\item{rowData}{A separate data frame with one row for each unstack grouping composed of the stackVar variables}
}
\description{
Unstack a column from a data frame and include additional variables.
}
\seealso{
\code{\link{Stack}}  (examples)
}
\author{
Øyvind Langsrud
}
