% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRTaffine.R
\name{srtsim_count_affine}
\alias{srtsim_count_affine}
\title{Generate Data with Estimated Parameters For A New Designed Pattern}
\usage{
srtsim_count_affine(
  simsrt,
  reflabel,
  targetlabel,
  breaktie = "random",
  nn_func = c("mean", "median", "ransam"),
  nn_num = 5,
  local_sid = NULL,
  numCores = 1
)
}
\arguments{
\item{simsrt}{A SRTsim object with estimated parameters from fitting step}

\item{reflabel}{A character vector specifying labels for reference regions}

\item{targetlabel}{A character vector specifying labels for target regions}

\item{breaktie}{A character string specifying how ties are treated.  Same as the "tie.method" in rank function}

\item{nn_func}{A character string specifying how the psedo-count to be generated. options include 'mean','median' and 'ransam'.}

\item{nn_num}{A integer of nearest neighbors, default is 5.}

\item{local_sid}{A numberic seed used locally for the affine transformation. Default is NULL.}

\item{numCores}{A number of cores to use}
}
\value{
Returns a SRTsim object with a newly generated count matrix
}
\description{
Generate Data with Estimated Parameters For A New Designed Pattern
}
\examples{

## Prepare Data From LIBD Sample
subinfo <- exampleLIBD$info[,c("imagecol","imagerow","layer")]
colnames(subinfo) <- c("x","y","label")
gns 	<- c("ENSG00000168314","ENSG00000183036", "ENSG00000132639" )

## Create a simSRT Object with Three Genes For a Fast Example
simSRT1 <- createSRT(count_in= exampleLIBD$count[gns,],loc_in =subinfo)

## Estimate model parameters for data generation: domain-specific 
simSRT1 <- srtsim_fit(simSRT1,sim_schem="domain")

## Define New Layer Structures
simSRT1@refcolData$target_label <- "NL1"
simSRT1@refcolData$target_label[simSRT1@refcolData$label \%in\% paste0("Layer",4:5)] <- "NL2"
simSRT1@refcolData$target_label[simSRT1@refcolData$label \%in\% c("Layer6","WM")] <- "NL3"

## Perform Data Generation for New Defined Layer Structures
## Reference: WM --> NL3, Layer5--> NL2, Layer3 --> NL1
simSRT1 <- srtsim_count_affine(simSRT1,
								reflabel=c("Layer3","Layer5","WM"),
								targetlabel=c("NL1","NL2","NL3"),
								nn_func="ransam"
								)

## Visualize the Expression Pattern for Gene of Interest
visualize_gene(simsrt=simSRT1,plotgn = "ENSG00000168314",rev_y=TRUE,ptsizeCount=1)
}
