\name{ampmap}
\docType{data}
\alias{ampmap}
\title{Mapping between amplicons and exons}
\description{
A matrix providing the mapping between ampilcons and exons. 
}
\usage{data(ampmap)
}
\format{
A matrix whose rows are 1 to the total number of the amplicons, columns
are

Column 1:"exon", the exon name.

Column 2:"exon_len", the length of the exon.

Column 3:"exon_start", the start position of the exon.

Column 4:"exon_end", the end position of the exon.

Column 5:"amplicon", a sequence fragment generated by PCR amplification.

Column 6:"amp_len", the length the amplicon.

Column 7:"amp_start", the start position of the amplicon.

Column 8:"amp_end", the end position of the amplicon.

}
\references{
Wang W, Shen P, Thyagarajan S, Lin S, Palm C, Horvath R, Klopstock T,
Cutler D, Pique L, Schrijver I, Davis RW, Mindrinos M, Speed TP, Scharfe
C. Identification of Rare DNA Variants in Mitochondrial Disorders with
Improved Array-based Sequencing. Nucleic Acids Res. 2011 Jan;39(1):44-58.

Shen P, Wang W, Krishnakumar S, Chi AK, Palm C, Enns GM, Davis RW, Speed TP, 
Mindrinos M, Scharfe C. High quality DNA sequence capture of 524 disease candidate genes. 
Proc Natl Acad Sci U S A. 2011 Apr 19;108(16):6549-54.
}
\keyword{datasets}
\examples{
data(ampmap)
ampmap[1:5,]
}