% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms.image_methods.R
\name{removeSmallObjects,ms.image-method}
\alias{removeSmallObjects,ms.image-method}
\alias{removeSmallObjects}
\title{Remove binary ROI objects smaller than user-defined number of pixels}
\usage{
\S4method{removeSmallObjects}{ms.image}(object, threshold = 5, border = 3)
}
\arguments{
\item{object}{\link{ms.image-class} object. See \link{msImage}.}

\item{threshold}{numeric. Smallest number of connected pixels.}

\item{border}{numeric (default = 3). Size of the empty border to add before
detecting the connected objects. The border is removed at the end of the
process. If `border = 0`, no border is added.}
}
\value{
\link{ms.image-class} object after filtering.
}
\description{
Remove binary ROI objects smaller than user-defined number of pixels
}
\examples{
library(SPUTNIK)

fakeBinImage <- matrix(0, 100, 100)
fakeBinImage[sample(prod(dim(fakeBinImage)), 2000)] <- 1

fakeBinMsImage <- msImage(values = fakeBinImage, name = "ROI", scale = FALSE)

# Remove the objects with a number of connected pixels smaller than 5
fakeBinMsImage <- removeSmallObjects(fakeBinMsImage, threshold = 5)
}
