% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\docType{methods}
\name{normIntensity,msi.dataset-method}
\alias{normIntensity,msi.dataset-method}
\alias{normIntensity}
\title{Normalize the peaks intensities.}
\usage{
\S4method{normIntensity}{msi.dataset}(object, method = "median")
}
\arguments{
\item{object}{\link{msi.dataset-class} object.}

\item{method}{String (default = \code{"median"}). the normalization method to
be used. Valid values are: \code{"TIC"}, \code{"median"}, or \code{"PQN"}.
See 'Details' section.}
}
\value{
object \link{msi.dataset-class} object, with normalized peaks
intensities.
}
\description{
Normalize the peaks intensities.
}
\details{
The valid values for \code{method} are:
\itemize{
  \item \code{"TIC"}: total ion current normalization assign the sum of the
  peaks intensities to one.
  \item \code{"median"}: median of spectrum intensities is scaled to one.
  \item \code{"PQN"}:
  \enumerate{
    \item apply \code{"TIC"} normalization
    \item calculate the median reference spectrum (after removing the zeros)
    \item calculate the quotients of peaks intensities and reference
    \item calculate the median of quotients for each peak (after removing the zeros)
    \item divide all the peak intensities by the median of quotients
  }
}
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2] * 20), sz[1]*sz[2], 20)
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Normalize and log-transform
msiX <- normIntensity(msiX, "median")
msiX <- varTransform(msiX, "log")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2]), sz[1]*sz[2], 20)
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Normalize using PQN
msiX <- normIntensity(msiX, "PQN")
}
\references{
F. Dieterle, A. Ross, G. Schlotterbeck, and Hans Senn. 2006.
Probabilistic quotient normalization as robust method to account for dilution
of complex biological mixtures. Application in 1H NMR metabonomics.
Analytical Chemistry 78(13): 4281-4290.
}
\seealso{
\link{msi.dataset-class}
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
