% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotQVI.R
\name{plotQVI}
\alias{plotQVI}
\title{plot variable importance comparison by quantile}
\usage{
plotQVI(object, var.index = NULL, var.names = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{SPQR}.}

\item{var.index}{A vector specifying the index of the covariates for which VI measures should be computed.
Default is \code{NULL} indicating all covariates are considered.}

\item{var.names}{The names of the covariates to appear in the bar plots. Default is \code{NULL} and the
the function will use generic names generated by \code{parse(text=paste0("X[",var.index,"]"))}.}

\item{...}{
  Arguments passed on to \code{\link[=QALE]{QALE}}
  \describe{
    \item{\code{tau}}{The quantiles of interest.}
    \item{\code{n.bins}}{the maximum number of intervals into which the covariate range is divided when
  calculating the ALEs. The actual number of intervals depends on the number of unique values in
\code{X[,var.index]}. When \code{length(var.index) = 2}, \code{n.bins} is applied to both covariates.}
    \item{\code{ci.level}}{The credible level for computing the pointwise credible intervals for ALE
when \code{length(var.index) = 1}. The default is 0 indicating no credible intervals should be computed.}
    \item{\code{pred.fun}}{A function that will be used instead of \code{predict.SPQR()}
for computing predicted quantiles given covariates. This can be useful when the user wants to compare
the QALE calculated using SPQR to that using other quantile regression models, or maybe that using
the true model in a simulation study.}
  }}
}
\value{
A \code{ggplot} object.
}
\description{
Computes the quantile ALE-induced variable importance (VI) measure for each of the
covariate specified in var.index, and produces a ranking plot of the covariates using
bar plot for each quantile of interest.
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- matrix(runif(n*2, 0, 2), nrow = n, ncol = 2)
Y <- rnorm(n, X[,1]^2, 0.3+X[,1]/2)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X=X, Y=Y, n.knots=12, n.hidden=5, method="MCMC",
            control=control, normalize=TRUE, verbose = FALSE)

## compute quantile VI of at tau = 0.2,0.5,0.8
plotQVI(fit, tau=c(0.2,0.5,0.8))
}

}
