% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlrTools.R
\name{plot_sensitivity}
\alias{plot_sensitivity}
\title{Sensitivity plot of a model}
\usage{
plot_sensitivity(
  object,
  s = 100,
  xlab = paste("x", 1:ncol(object$x), sep = ""),
  ylab = "y",
  type = "best",
  agg.sample = 100,
  agg.fun = mean,
  ...
)
}
\arguments{
\item{object}{the result list returned by \code{\link[SPOT]{spot}}, importantly including a \code{modelFit}, and the data \code{x}, \code{y}.}

\item{s}{number of samples along each dimension.}

\item{xlab}{a vector of characters, giving the labels for each of the two independent variables.}

\item{ylab}{character, the value of the dependent variable predicted by the corresponding model.}

\item{type}{string describing the type of the plot:  \code{"best"} (default) shows sensitivity around optimum, \code{"contour"},
\code{"persp"} (perspective), or \code{"persp3d"} plot.
Note that "persp3d" is based on the plotly package and will work in RStudio, but not in the standard RGui.}

\item{agg.sample}{number of samples for aggregation type (type="agg").}

\item{agg.fun}{function for aggregation (type="agg").}

\item{...}{additional parameters (currently unused).}
}
\value{
plotly visualization (based on \code{\link[plotly]{plot_ly}})
}
\description{
mlrTools
}
\seealso{
\code{\link[SPOT]{plotFunction}}, \code{\link[SPOT]{plotData}}
}
