% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startCensusRun.R
\name{startCensusRun}
\alias{startCensusRun}
\title{Start hyperparameter optimization runs with spot based on US census data}
\usage{
startCensusRun(
  modelList = list("dl", "cvglmnet", "kknn", "ranger", "rpart", "svm", "xgboost"),
  runNr = "000",
  SPOTVersion = "2.10.12",
  SPOTMiscVersion = "1.19.2",
  timebudget = 3600,
  target = "age",
  cachedir = "oml.cache",
  task.type = "classif",
  nobs = 10000,
  nfactors = "high",
  nnumericals = "high",
  cardinality = "high",
  data.seed = 1,
  prop = 2/3,
  batch_size = 32,
  tuner.seed = 1,
  returnValue = "validationLoss",
  initSizeFactor = 2,
  spotModel = buildKriging,
  spotOptim = optimDE,
  lower = NULL,
  upper = NULL,
  noise = TRUE,
  OCBA = TRUE,
  OCBABudget = 3,
  multiStart = 2,
  multFun = 200,
  handleNAsMethod = handleNAsMean,
  imputeCriteriaFuns = list(is.infinite, is.na, is.nan),
  krigingTarget = "ei",
  krigingUseLambda = TRUE,
  krigingReinterpolate = FALSE,
  defaultAsStartingPoint = TRUE,
  plots = FALSE,
  Rinit = 2,
  replicates = 2,
  resDummy = FALSE,
  verbosity = 0
)
}
\arguments{
\item{modelList}{list of models. Default:
\code{list("dl", "cvglmnet",  "kknn",   "ranger", "rpart" ,  "svm", "xgboost")}}

\item{runNr}{character, specifies the run number. Default: \code{"000"}}

\item{SPOTVersion}{smallest package version number}

\item{SPOTMiscVersion}{smallest package version number}

\item{timebudget}{time budget Default:  \code{3600} (secs)}

\item{target}{target "age"}

\item{cachedir}{cache dir "oml.cache"}

\item{task.type}{task type "classif"}

\item{nobs}{number of observations 1e4}

\item{nfactors}{number of factorial variables "high"}

\item{nnumericals}{number of numerical variables "high"}

\item{cardinality}{cardinality "high"}

\item{data.seed}{1}

\item{prop}{proportion 2 / 3}

\item{batch_size}{batch size (for dl) 32}

\item{tuner.seed}{seed for SPOT  1}

\item{returnValue}{"validationLoss"}

\item{initSizeFactor}{multiplier for the initial design size 2}

\item{spotModel}{buildKriging}

\item{spotOptim}{optimDE}

\item{lower}{NULL}

\item{upper}{NULL}

\item{noise}{TRUE}

\item{OCBA}{TRUE}

\item{OCBABudget}{3}

\item{multiStart}{2}

\item{multFun}{200}

\item{handleNAsMethod}{handleNAsMean}

\item{imputeCriteriaFuns}{list(is.infinite, is.na, is.nan)}

\item{krigingTarget}{"ei"}

\item{krigingUseLambda}{TRUE}

\item{krigingReinterpolate}{FALSE}

\item{defaultAsStartingPoint}{TRUE}

\item{plots}{FALSE}

\item{Rinit}{2}

\item{replicates}{2}

\item{resDummy}{FALSE}

\item{verbosity}{0}
}
\description{
Runs to compare standard machine learning and deep learning models
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE <- FALSE
if(PYTHON_RETICULATE){
library("dplyr")
library("farff")
library("GGally")
library("keras")
library("tensorflow")
library("Metrics")
library("mlr")
library("reticulate")
library("rpart")
library("rpart.plot")
library("SPOT")
library("SPOTMisc")
library("tfdatasets")
library("rsample")
startCensusRun(modelList=list("ranger", timebudget=60))
}
}

}
