% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot.R
\name{spot}
\alias{spot}
\title{spot}
\usage{
spot(x = NULL, fun, lower, upper, control = list(), ...)
}
\arguments{
\item{x}{is an optional start point (or set of start points), specified as a matrix. One row for each point, and one column for each optimized parameter.}

\item{fun}{is the objective function. It should receive a matrix x and return a matrix y. 
In case the function uses external code and is noisy, an additional seed parameter may be used, see the \code{control$seedFun} argument below for details.
Mostly, fun must have format y = f(x, ...). If a noisy function requires some specific seed handling, e.g., in some other non-R code,
a seed can be passed to fun. For that purpose, the user must specify \code{control$noise = TRUE} and fun should be \code{fun(x, seed, ...)}}

\item{lower}{is a vector that defines the lower boundary of search space. This determines also the dimensionality of the problem.}

\item{upper}{is a vector that defines the upper boundary of search space.}

\item{control}{is a list with control settings for spot. See \code{\link{spotControl}}.}

\item{...}{additional parameters passed to \code{fun}.}
}
\value{
This function returns a list with:
\describe{
	\item{\code{xbest}}{Parameters of the best found solution (matrix).}
	\item{\code{ybest}}{Objective function value of the best found solution (matrix).}
	\item{\code{x}}{Archive of all evaluation parameters (matrix).}
	\item{\code{y}}{Archive of the respective objective function values (matrix).}
	\item{\code{count}}{Number of performed objective function evaluations.}
	\item{\code{msg}}{Message specifying the reason of termination.}
	\item{\code{modelFit}}{The fit of the last build model, i.e., an object returned by the last call to the function specified by \code{control$model}.}
}
}
\description{
Sequential Parameter Optimization.
This is one of the main interfaces for using the SPOT package. Based on a user-given objective function
and configuration, \code{spot} finds the parameter setting that yields the lowest objective value (minimization).
To that end, it uses methods from the fields of design of experiment, statistical modeling / machine learning
and optimization.
}
\examples{
## Only a few examples. More examples can be found in the vignette and in  
## the paper "In a Nutshell -- The Sequential Parameter Optimization Toolbox", 
## see https://arxiv.org/abs/1712.04076

## 1. Most simple example: Kriging + LHS search + predicted mean optimization 
## (not expected improvement)
set.seed(1)
res <- spot(,funSphere,c(-2,-3),c(1,2),
             control=list(funEvals=15))
res$xbest
res$ybest

## 2. With expected improvement
set.seed(1)
res <- spot(,funSphere,c(-2,-3),c(1,2),
            control=list(funEvals=15,
                         modelControl=list(target="ei")))
res$xbest
res$ybest

### 3. Use local optimization instead of LHS search
set.seed(1)
res <- spot(,funSphere,c(-2,-3),c(1,2),
            control=list(funEvals=15,
                         modelControl=list(target="ei"),
                         optimizer=optimLBFGSB))
res$xbest
res$ybest


}
