% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funError.R
\name{funError}
\alias{funError}
\title{funError}
\usage{
funError(x, prob = 0.1, errorList = list(NA, Inf, NaN), outDim = 1)
}
\arguments{
\item{x}{input vector or matrix of candidate solution}

\item{prob}{error probability (0<prob<1). Default: 0.1}

\item{errorList}{list with error types. Default: \code{list(NA, Inf, NaN)}}

\item{outDim}{dimension of the output matrix (number of columns)}
}
\value{
vector of objective function values
}
\description{
Simulate NAs, Infs, NaNs in results from objective function evaluations
}
\details{
Results from \code{\link{funSphere}} are replaced with \code{NA}, \code{NaN}, and \code{Inf}
values.
}
\examples{
set.seed(123)
require(SPOT)
x <- matrix(1:10, 5,2)
y <- funError(x)
any(is.na(y))
## two-dim output
funError(x,outDim=2)
funError(x,outDim=2, prob=0.1)


}
\seealso{
\code{\link{is.finite}}
}
