% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotPredictCoForrester.R
\name{forrCoBuilder}
\alias{forrCoBuilder}
\title{Build Forrester Co-Kriging}
\usage{
forrCoBuilder(Xe, ye, Xc, yc, fitC, lb = NULL, ub = NULL,
  control = list())
}
\arguments{
\item{Xe}{design matrix (expensive sample locations)}

\item{ye}{1-row matrix of expensive observations at Xe}

\item{Xc}{design matrix (cheap sample locations). The bottom of this matrix should contain expensive samples.}

\item{yc}{1-row matrix of cheap observations at Xc.}

\item{fitC}{object of class \code{forr}, containing a Kriging model build through the cheap observations}

\item{lb}{lower boundary of the design space. Will be extracted from the matrix \code{Xe} if not given.}

\item{ub}{upper boundary of the design space. Will be extracted from the matrix \code{Xe} if not given.}

\item{control}{(list), with the options for the model building procedure:\cr
\code{loval} lower boundary for theta, default is \code{1e-6}\cr
\code{upval} upper boundary for theta, default is \code{100}\cr
\code{corr} function to be used for correlation modeling, default is \code{fcorrGauss}\cr
\code{algtheta}  algorithm used to find theta, default is \code{"NLOPT_LN_NELDERMEAD"}. Else, any from the list of possible \code{method} values in \code{spotOptimizationInterface} from the SPOT package can be chosen.\cr
\code{budgetalgtheta} budget for the above mentioned algorithm, default is \code{100}. The value will be multiplied with the length of the model parameter vector to be optimized.
\code{opt.p} boolean that specifies whether the exponents (\code{p}) should be optimized. Else they will be set to two. \cr
\code{uselambda} whether or not to use the regularization constant lambda (nugget effect). Default is \code{FALSE}.
\code{lambda.loval} lower boundary for lambda, default is \code{-6}\cr
\code{lambda.upval} upper boundary for lambda, default is \code{0}\cr
\code{rho.loval} lower boundary for rho, default is \code{-5}\cr
\code{rho.upval} upper boundary for rho, default is \code{5}\cr
\code{starttheta} optional start value for theta.
\code{reinterpolate} whether (TRUE) or not (FALSE, default) reinterpolation should be performed}
}
\value{
a fit (list) of class \code{coforr}. This contains Co-Kriging specific parameters, as well as two fits of class \code{forr} which represent the cheap and expensive models.
}
\description{
This function builds a Co-Kriging model based on code by Forrester et al..
Please note that the expensive sample locations should be contained in the cheap sample locations.
Furthermore, it has to be made sure that the correlated functions do not yield identical values.
That is, \code{ye} and \code{yc} should have common sample locations, but different values.
The sample locations only evaluated on the cheap function can be chosen arbitrarily.
}
\examples{
## This is the one-variable example described by Forrester et al.
	## The "expensive" function to be modeled is
	ovar <- function(x){(x*6-2)^2*sin((x*6-2)*2)}
	## The "cheap" function to be modeled is
	covar <- function(x){ A=0.5;B=10;C=-5;D=0;
		A*(((x+D)*6-2)^2)*sin(((x+D)*6-2)*2)+((x+D)-0.5)*B+C
	}
	## construct cheap and expensive sample locations
	xe <- rbind(0,0.4,0.6,1)
	xc <- rbind(0.1,0.2,0.3,0.5,0.7,0.8,0.9,0,0.4,0.6,1)
	## get observations of samples
	ye <- rbind(ovar(xe))
	yc <- rbind(covar(xc))
	## build the Co-Kriging model, with cheap and expensive observations
	set.seed(1)
 fitC <- forrBuilder(xc, yc)
	fit <- forrCoBuilder(xe, ye, xc, yc, fitC)
	## build the ordinary Kriging model with expensive observations only
	fit1 <- forrBuilder(xe, ye)
 ## Predict and plot over whole design space
	x<-seq(from=0,to=1,by=0.01)
	yco <- forrCoRegPredictor(as.matrix(x),fit,FALSE)$f
	ypc <- predict(fitC,as.matrix(x),FALSE)$f
	fit2 <- fit
 class(fit2) <- "forr"
	ype <- predict(fit2,as.matrix(x),FALSE)$f
	yy <- predict(fit1,as.matrix(x),FALSE)$f
	plot(x,ovar(x),type="l",ylim=c(-15,20),lwd=3)
	points(xe,ye,pch=19,cex=1.5)
	points(xc,yc,cex=1.5)
	lines(x,covar(x),lwd=3)
	lines(x,ype,col="blue",lwd=3) #difference model
	lines(x,ypc,col="red",lty=4,lwd=3) 	#cheap model
	lines(x,yy,col="blue",lty=3,lwd=3)#uncorrected model
	lines(x,yco,col="darkgreen",lty=5,lwd=3) #comodel
	legend("top",lwd=c(3,3,1,1,3,3,3,3),
		col=c("black","black","black","black","blue","red","blue","darkgreen"),
		legend=	c("Expensive Function", "Cheap Function",
				"Expensive Observations", "Cheap Observations",
				"Uncorrected Model", "Cheap Model","Difference Model",
				"Co-Kriging Model"),
		lty=c(1,1,0,0,3,4,1,5),pch=c(NA,NA,19,1,NA,NA,NA,NA))
	sum((yco-ovar(x))^2)/length(x) #mse
}
\references{
Forrester, Alexander I.J.; Sobester, Andras; Keane, Andy J. (2008). Engineering Design via Surrogate Modelling - A Practical Guide. John Wiley & Sons.

FORRESTER, A.I.J, SOBESTER A. & KEAN, A.J. (2007), Multi-Fidelity optimization via surrogate modelling. \emph{Proc. R. Soc. A} 463, 3251-3269. \cr
Forrester, Alexander I.J.; Sobester, Andras; Keane, Andy J. (2008). Engineering Design via Surrogate Modelling - A Practical Guide. John Wiley & Sons.
}
\seealso{
\code{\link{spotPredictCoForrester}} \code{\link{forrCoRegPredictor}} \code{\link{forrBuilder}}
}

