% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{getcal}
\alias{getcal}
\title{getcal()}
\usage{
getcal(
  y,
  ypred,
  n = 10,
  kernel = FALSE,
  kernel_sd = 0.05,
  alpha = 0.05,
  c0 = 0,
  c2 = 0.1
)
}
\arguments{
\item{y}{class labels, 0/1 or logical}

\item{ypred}{predictions Pr(Y=1), numeric vector}

\item{n}{number of subintervals/points}

\item{kernel}{set to TRUE to use kernel method}

\item{kernel_sd}{kernel width for kernel method; see above}

\item{alpha}{return a pointwise confidence envolope for conservative 1-alpha confidence interval}

\item{c0}{for computing maximum bias; assume true covariance function is of the form a0+ a1x + a2x^2, with |a0|<c0, |a2|<c2 (c1 does not matter)}

\item{c2}{for computing maximum bias; assume true covariance function is of the form a0+ a1x + a2x^2, with |a0|<c0, |a2|<c2 (c1 does not matter)}
}
\value{
a list with components x (expected calibration), y (observed calibration), n (number of samples in bins, if relevant), lower/upper (confidence interval on y)
}
\description{
Produces a set of points for a calibration plot.
}
\details{
Uses either a binning method or a kernel method to determine height of points.

In both methods, considers n equally spaced subintervals of (0,1)
}
\examples{
# See vignette
}
