% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/S3_MeanSquaredError.R
\name{mse.numeric}
\alias{mse.numeric}
\alias{weighted.mse.numeric}
\alias{mse}
\alias{weighted.mse}
\title{Mean Squared Error}
\usage{
\method{mse}{numeric}(actual, predicted, ...)

\method{weighted.mse}{numeric}(actual, predicted, w, ...)

## Generic S3 method
mse(
 actual,
 predicted,
 ...
)

## Generic S3 method
weighted.mse(
 actual,
 predicted,
 w,
 ...
)
}
\arguments{
\item{actual}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The observed (continuous) response variable.}

\item{predicted}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The estimated (continuous) response variable.}

\item{...}{Arguments passed into other methods.}

\item{w}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The weight assigned to each observation in the data.}
}
\value{
A <\link{numeric}> vector of \link{length} 1.
}
\description{
The \code{\link[=mse]{mse()}}-function computes the \href{https://en.wikipedia.org/wiki/Mean_squared_error}{mean squared error} between
the observed and predicted <\link{numeric}> vectors. The \code{\link[=weighted.mse]{weighted.mse()}} function computes the weighted mean squared error.
}
\section{Definition}{


The metric is calculated as,

\deqn{
  \frac{1}{n} \sum_i^n (y_i - \upsilon_i)^2
}

Where \eqn{y_i} and \eqn{\upsilon_i} are the \code{actual} and \code{predicted} values respectively.
}

\examples{
# 1) fit a linear
# regression
model <- lm(
  mpg ~ .,
  data = mtcars
)

# 1.1) define actual
# and predicted values
# to measure performance
actual    <- mtcars$mpg
predicted <- fitted(model)

# 2) evaluate in-sample model
# performance using Mean Squared Error (MSE)
cat(
  "Mean Squared Error", mse(
    actual    = actual,
    predicted = predicted,
  ),
  "Mean Squared Error (weighted)", weighted.mse(
    actual    = actual,
    predicted = predicted,
    w         = mtcars$mpg/mean(mtcars$mpg)
  ),
  sep = "\n"
)
}
\seealso{
Other Regression: 
\code{\link{ccc.numeric}()},
\code{\link{huberloss.numeric}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mpe.numeric}()},
\code{\link{pinball.numeric}()},
\code{\link{rae.numeric}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{rrmse.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{rsq.numeric}()},
\code{\link{smape.numeric}()}

Other Supervised Learning: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ccc.numeric}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fpr.factor}()},
\code{\link{huberloss.numeric}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mcc.factor}()},
\code{\link{mpe.numeric}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{pinball.numeric}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{rae.numeric}()},
\code{\link{recall.factor}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{roc.auc.matrix}()},
\code{\link{rrmse.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{rsq.numeric}()},
\code{\link{smape.numeric}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}
}
\concept{Regression}
\concept{Supervised Learning}
