% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap.clus.R
\name{gap.clus}
\alias{gap.clus}
\title{Gap statistics}
\usage{
gap.clus(DistanceMatrix, Clusters, B)
}
\arguments{
\item{DistanceMatrix}{Square matrix of GCC distances.}

\item{Clusters}{Matrix of member labels.}

\item{B}{Number of iterations for the bootstrap.}
}
\value{
A list containing:
\itemize{
\item - optim.k: number of groups.
\item - gap.values: gap values.
}
}
\description{
This function computes the gap and the number of groups using the gap statistics.
}
\examples{
data(TaiwanAirBox032017)
library(TSclust)
z <- diff(as.matrix(TaiwanAirBox032017[1:50,1:8]))
Macf <- as.matrix(diss(t(z), METHOD = "ACF", lag.max = 5))
sc1 <- hclust(as.dist(Macf), method = "complete")
memb <- cutree(sc1, 1:8)

ngroups <- gap.clus(Macf, memb, 100)


}
\references{
Alonso, A. M. and Peña, D. (2019). Clustering time series by linear
dependency. \emph{Statistics and Computing}, 29(4):655–676.
}
