% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateSIT.R
\name{calculateSIT}
\alias{calculateSIT}
\alias{sitcorcoefficient}
\title{Compute the cross rank coefficient sit on two vectors.}
\usage{
calculateSIT(x, y, c = 2)
}
\arguments{
\item{x}{Vector of numeric values in the first coordinate.}

\item{y}{Vector of numeric values in the second coordinate.}

\item{c}{The number of observations in each slice.}
}
\value{
The function returns the value of the
sit
coefficient.
}
\description{
This function computes the sit coefficient between two vectors x and y.
}
\note{
Auxiliary function with no checks for NA, etc.
}
\examples{
# Compute one of the coefficients
library("psychTools")
data(peas)
calculateSIT(peas$parent,peas$child)
calculateSIT(peas$child,peas$parent)
}
\references{
Zhang Y., Chen C., & Zhu L. (2021). Sliced Independence Test. Statistica Sinica. https://doi.org/10.5705/ss.202021.0203.
}
\seealso{
sitcor
}
\author{
Yilin Zhang, Canyi Chen & Liping Zhu
}
\keyword{~htest}
\keyword{~methods}
