% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_decompose.R
\name{causal.decompose}
\alias{causal.decompose}
\title{Estimation and decomposition of simultaneous equation model}
\usage{
causal.decompose(data, eq.system, resid.est = "noDfCor", instruments,
  p.adj = TRUE, alpha = 0.05)
}
\arguments{
\item{data}{the data frame containing the data}

\item{eq.system}{the system of equations (a list of formula objects, e.g. as in pkg systemfit)}

\item{resid.est}{the estimation methods for the residual covariance matrix (as in pkg systemfit)}

\item{instruments}{the intruments used to estimate the model via 3-SLS (as in pkg systemfit)}

\item{p.adj}{logical indication of whether to adjust the significance level
for multiple comparisons, when testing the significance of the elements of \eqn{\Sigma}}

\item{alpha}{the significance level \eqn{\alpha} for the tests on the elements of \eqn{\Sigma}}
}
\value{
A list with components \itemize{
\item \code{output}: a list containing\itemize{
\item \code{eq.system}: the system of equations given as input
\item \code{Gamma}: the 3-SLS estimate of \eqn{\Gamma'}
\item \code{C}: the matrix highlighting the interdependent mechanisms at deterministic level.
\item \code{Psi1}: the matrix highlighting the interdependent mechanisms at stochastic level.
\item \code{Psi0}: the matrix highlighting the causal mechanisms.
\item \code{A}: the 3-SLS estimate of \eqn{A}
\item \code{Sigma}: the 3-SLS estimate of \eqn{Sigma}, with non-significant
elements set to zero
\item \code{systemfit}: the output from the \code{systemfit} function used to
estimate the model
\item \code{corrtest}: the output from the \code{corr.test} function used to
test the significance on the elements of the residual correlation matrix
\item \code{all.graph}: the path diagram of the model, using the package \code{igraph}
\item \code{dec.graph}: the path diagram of the decomposed model, with color
coding for each vertex}
\item \code{path}: a data frame in which every row is a path coefficient,
along with indication of the nature of the link (recursive/interdependent)
and the index of the equation in which it belongs
}
}
\description{
Estimate and decompose
a Simultaneous Equation Model into its recursive
and Interdependent sub-systems
}
\examples{
data("macroIT")
eq.system = list(
               eq1 = C ~  CP  + I + CP_1,
               eq2 = I ~ K + CP_1,
               eq3 = WP ~ I + GDP + GDP_1,
               eq4 = GDP ~ C + I + GDP_1,
               eq5 = CP ~ WP + T,
               eq6 = K ~ I + K_1)

instruments = ~ T + CP_1 + GDP_1 + K_1

causal.decompose(data = macroIT,
               eq.system = eq.system,
               resid.est = "noDfCor",
               instruments = instruments,
               p.adj = TRUE,
               alpha = 0.05)
}
