% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L1_Pop.R
\name{createCastePop}
\alias{createCastePop}
\alias{createWorkers}
\alias{createDrones}
\alias{createVirginQueens}
\title{Creates caste population individuals from the colony}
\usage{
createCastePop(
  x,
  caste = NULL,
  nInd = NULL,
  exact = TRUE,
  year = NULL,
  editCsd = TRUE,
  csdAlleles = NULL,
  simParamBee = NULL,
  ...
)

createWorkers(x, nInd = NULL, exact = FALSE, simParamBee = NULL, ...)

createDrones(x, nInd = NULL, simParamBee = NULL, ...)

createVirginQueens(
  x,
  nInd = NULL,
  year = NULL,
  editCsd = TRUE,
  csdAlleles = NULL,
  simParamBee = NULL,
  ...
)
}
\arguments{
\item{x}{\code{link{MapPop-class}} (only if caste is "virginQueens"), or
\code{Pop} (only if caste is "drones") or \code{\link{Colony-class}}
or \code{\link{MultiColony-class}}}

\item{caste}{character, "workers", "drones", or "virginQueens"}

\item{nInd}{numeric or function, number of caste individuals; if \code{NULL} then
\code{\link{SimParamBee}$nWorkers},  \code{\link{SimParamBee}$nDrones}
or \code{\link{SimParamBee}$nVirginQueens} is used depending on the caste;
only used when \code{x} is \code{\link{Colony-class}} or
\code{\link{MultiColony-class}}, when \code{x} is \code{link{MapPop-class}}
all individuals in \code{x} are converted into virgin queens}

\item{exact}{logical, only relevant when creating workers,
if the csd locus is active and exact is \code{TRUE},
create the exactly specified number of viable workers (heterozygous on the
csd locus)}

\item{year}{numeric, year of birth for virgin queens}

\item{editCsd}{logical (only active when \code{x} is \code{link{MapPop-class}}),
whether the csd locus should be edited to ensure heterozygosity at the csd
locus (to get viable virgin queens); see \code{csdAlleles}}

\item{csdAlleles}{\code{NULL} or list (only active when \code{x} is \code{link{MapPop-class}});
If \code{NULL}, then the function samples a heterozygous csd genotype for
each virgin queen from all possible csd alleles.
If not \code{NULL}, the user provides a list of length \code{nInd} with each
node holding a matrix or a data.frame, each having two rows and n columns.
Each row must hold one csd haplotype (allele) that will be assigned to a
virgin queen. The n columns span the length of the csd locus as specified
in \code{\link{SimParamBee}}. The two csd alleles must be different to
ensure heterozygosity at the csd locus.}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}

\item{...}{additional arguments passed to \code{nInd} when this argument is a function}
}
\value{
when \code{x} is \code{link{MapPop-class}} returns
  \code{virginQueens} (a \code{\link{Pop-class}});
  when \code{x} is \code{\link{Colony-class}} returns
  \code{virginQueens} (a \code{\link{Pop-class}});
  when \code{x} is \code{\link{MultiColony-class}}
  return is a named list of \code{virginQueens} (a \code{\link{Pop-class}});
  named by colony ID
}
\description{
Level 1 function that creates the specified number of caste
  individuals from the colony with a mated queens. If csd
  locus is active, it takes it into account and any csd homozygotes are
  removed and counted towards homozygous brood.
}
\section{Functions}{
\itemize{
\item \code{createWorkers()}: Create workers from a colony

\item \code{createDrones()}: Create drones from a colony

\item \code{createVirginQueens()}: Create virgin queens from a colony

}}
\examples{
founderGenomes <- quickHaplo(nInd = 4, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
SP$setTrackRec(TRUE)
SP$setTrackPed(isTrackPed = TRUE)

# Create virgin queens on a MapPop
basePop <- createCastePop(founderGenomes, caste = "virginQueens")
# Or alias
createVirginQueens(founderGenomes)
# Same aliases exist for all the castes!!!

# Create drones on a Pop
drones <- createDrones(x = basePop[1],  nInd = 200)
# Or create unequal number of drones from multiple virgin queens
drones <- createDrones(basePop[1:2], nInd = c(100, 200))
droneGroups <- pullDroneGroupsFromDCA(drones, n = 3, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])

# Using default nInd in SP
colony@virginQueens <- createVirginQueens(colony)
colony@workers <- createWorkers(colony)$workers
colony@drones <- createDrones(colony)
# Usually, you would use functions buildUp() or addCastePop()

# These populations hold individual information
# Example on the virgin queens (same holds for all castes!)
virginQueens <- colony@virginQueens
virginQueens@id
virginQueens@sex
virginQueens@mother
virginQueens@father

# Specify own number
SP$nVirginQueens <- 15
SP$nWorkers <- 100
SP$nDrones <- 10
createVirginQueens(colony)
createVirginQueens(apiary)
# Or creating unequal numbers
createVirginQueens(apiary, nInd = c(5, 10))
# nVirginQueens will NOT vary between function calls when a constant is used

# Specify a function that will give a number
createVirginQueens(colony, nInd = nVirginQueensPoisson)
createVirginQueens(apiary, nInd = nVirginQueensPoisson)
# No. of individuals will vary between function calls when a function is used

# Store a function or a value in the SP object
SP$nVirginQueens <- nVirginQueensPoisson
createVirginQueens(colony)
createVirginQueens(colony)
createVirginQueens(apiary)
createVirginQueens(apiary)
# No. of individuals will vary between function calls when a function is used

# csd homozygosity - relevant when creating virgin queens
SP <- SimParamBee$new(founderGenomes, csdChr = 1, nCsdAlleles = 8)
basePop <- createVirginQueens(founderGenomes, editCsd = FALSE)
all(isCsdHeterozygous(basePop))

basePop <- createVirginQueens(founderGenomes, editCsd = TRUE)
all(isCsdHeterozygous(basePop))
}
