% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dichotomize.dataset.R
\name{dichotomize.dataset}
\alias{dichotomize.dataset}
\title{Dichotomize a single dataset}
\usage{
dichotomize.dataset(x, split.at = "median")
}
\arguments{
\item{x}{A vector of values to be dichotomized}

\item{split.at}{An character string or a numeric value that is be used to dichotomize. 
Valid values are: 'median', 'mean', or a user defined numeric threshold. Defaults to
'median'}
}
\value{
A vector of the data dichotomized onto a 0/1 (low/high) scale.
}
\description{
Split a dataset into two groups by median-dichotomization
}
\examples{

tmp <- rnorm(100);
tmp.groups.median <- dichotomize.dataset(tmp);
tmp.groups.mean <- dichotomize.dataset(tmp, split.at = "mean");
tmp.groups.custom <- dichotomize.dataset(tmp, split.at = 0.3);

}
\author{
Syed Haider & Paul C. Boutros
}
\keyword{survival}
