% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSiberCommunity.R
\name{generateSiberCommunity}
\alias{generateSiberCommunity}
\title{A utility function to simulate a single community comprised of groups}
\usage{
generateSiberCommunity(
  n.groups = 3,
  community.id = 1,
  n.obs = 30,
  mu.range = c(-1, 1, -1, 1),
  wishSigmaScale = 1
)
}
\arguments{
\item{n.groups}{the an integer specifying the number of groups to simulate. 
Defaults to 3.}

\item{community.id}{an integer identifying the community's ID number. 
Defaults to 1.}

\item{n.obs}{the number of observations to draw per group.}

\item{mu.range}{a vector of length 4, specifying the mix and max x and y 
values to sample means from. Group means are sampled from a uniform 
distribution within this range. The first two entries are the min and max of 
the x-axis, and the second two the min and max of the y-axis.  Defaults to 
\code{c(-1, 1, -1, 1)}.}

\item{wishSigmaScale}{is a simple multiplier for the call to
\code{\link[stats]{rWishart}} which scales the diagonal sigma matrix using
\code{wishSigmaScale * diag(2)} that is ultimately passed on to 
\code{\link{generateSiberGroup}}.}
}
\value{
A data.frame object comprising a column of x and y data, a group 
identifying column and a community identifying column, all of which are 
numeric.
}
\description{
This function simulates data for a single community by sampling from a normal
distribution with different means for each group within some specified 
boundaries.
}
