% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communityMetricsML.R
\name{communityMetricsML}
\alias{communityMetricsML}
\title{Calculate the point estimates of the Layman metrics for each community}
\usage{
communityMetricsML(siber)
}
\arguments{
\item{siber}{a siber object as created by createSiberObject.R}
}
\value{
A 6 x m matrix of the 6 Layman metrics of dX_range, dY_range, TA, 
CD, MNND and SDNND in rows, for each community by column
}
\description{
This function loops over each community, determines the centre of mass 
(centroid) of each of the groups comprising the community using the basic 
\code{\link[base]{mean}} function independently on the marginal x and y vectors,
and calculates the corresponding 6 Layman metrics based on these points.
}
\examples{
data(demo.siber.data)
my.siber.data <- createSiberObject(demo.siber.data)
communityMetricsML(my.siber.data)

}
