% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmaSEA.R
\name{sigmaSEA}
\alias{sigmaSEA}
\title{Calculate metrics corresponding to the Standard Ellipse based on a 
covariance matrix}
\usage{
sigmaSEA(sigma)
}
\arguments{
\item{sigma}{a 2x2 covariance ellipse.}
}
\value{
A list comprising the following metrics for summarising the Standard 
Ellipse
#' \itemize{
   \item {SEA}{the Standard Ellise Area (not sample size corrected)}
   \item {eccentricity}{a measure of the elongation of the ellipse.}
   \item {a}{the length of the semi-major axis}
   \item {b}{the length of the semi-minor axis}
}
}
\description{
This function takes a covariance 2x2 matrix Sigma and returns various 
metrics relating to the corresponding Standard Ellipse.
}
\section{Note}{
 This function is currently based on the eigenvalue and 
  eigenvector approach which is more flexible for higher dimensional problems
  method for calculating the standard ellipse, and replaces the parametric
  method used previously in siar and siber.
}
\examples{
# A perfect circle
sigma <- matrix( c(1, 0, 0, 1), 2, 2)
sigmaSEA(sigma)

}

