% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_module_project.R
\name{create_module_project}
\alias{create_module_project}
\title{Create a new RStudio project prepared for SIA modules}
\usage{
create_module_project(path, ..., open = TRUE)
}
\arguments{
\item{path}{\emph{character}, a path to the new module. Use \code{"../my_new_module"}
to create a module in the parent of the current working directory.}

\item{...}{\emph{used by RStudio only}}

\item{open}{\emph{logical}, whether to open the project in new RStudio session
after creation. Defaults to \code{TRUE}.}
}
\value{
No return value. Called for the side effect.
}
\description{
The function is designed to be used primarily by RStudio "New Project
Wizard". Create a new project by navigating through File > New Project > New
Directory > ShinyItemAnalysis Module Project. See \href{https://docs.posit.co/ide/user/ide/guide/productivity/project-templates.html}{RStudio User Guide}
for the details.
}
\examples{
if (interactive()) {
# create a new SIA module project in the parent of your working directory
create_module_project("../my_new_module")
}
}
\concept{project_templates}
