% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meank.2007Schott.R
\name{meank.2007Schott}
\alias{meank.2007Schott}
\title{Test for Equality of Means by Schott (2007)}
\usage{
meank.2007Schott(dlist)
}
\arguments{
\item{dlist}{a list of length \eqn{k} where each element is a sample matrix of same dimension.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given univariate samples \eqn{X_1~,\ldots,~X_k}, it tests
\deqn{H_0 : \mu_1 = \cdots \mu_k\quad vs\quad H_1 : \textrm{at least one equality does not hold}}
using the procedure by Schott (2007). It can be considered as a generalization 
of two-sample testing procedure proposed by \code{\link[SHT:mean2.1996BS]{Bai and Saranadasa (1996)}}.
}
\examples{
## CRAN-purpose small example
tinylist = list()
for (i in 1:3){ # consider 3-sample case
  tinylist[[i]] = matrix(rnorm(10*3),ncol=3)
}
meank.2007Schott(tinylist)

\donttest{
## test when k=5 samples with (n,p) = (10,50)
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  mylist = list()
  for (j in 1:5){
     mylist[[j]] = matrix(rnorm(10*5),ncol=5)
  }
  
  counter[i] = ifelse(meank.2007Schott(mylist)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'meank.2007Schott'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}


}
\references{
\insertRef{schott_highdimensional_2007}{SHT}
}
\concept{mean_multivariate}
