% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim2.2018HN.R
\name{sim2.2018HN}
\alias{sim2.2018HN}
\title{Two-sample Simultaneous Test of Means and Covariances by Hyodo and Nishiyama (2018)}
\usage{
sim2.2018HN(X, Y)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value \eqn{P(H_0|H_1)} under current setting.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given a multivariate sample \eqn{X}, hypothesized mean \eqn{\mu_0} and covariance \eqn{\Sigma_0}, it tests
\deqn{H_0 : \mu_x = \mu_y \textrm{ and } \Sigma_x = \Sigma_y \quad vs\quad H_1 : \textrm{ not } H_0}
using the procedure by Hyodo and Nishiyama (2018) in a similar fashion to that of Liu et al. (2017) for 
one-sample test.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
smallY = matrix(rnorm(10*3),ncol=3)
sim2.2018HN(smallX, smallY) # run the test

\donttest{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(121*10), ncol=10)
  Y = matrix(rnorm(169*10), ncol=10)
  counter[i] = ifelse(sim2.2018HN(X,Y)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\\n* Example for 'sim2.2018HN'\\n\\n",
sprintf("* number of rejections   : \%d\\n",sum(counter)),
sprintf("* total number of trials : \%d\\n",niter),
sprintf("* empirical Type 1 error : \%.4f\\n", sum(counter/niter)),sep=""))
}

}
\references{
\insertRef{hyodo_simultaneous_2018}{SHT}
}
