% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdffeedback.R
\name{cdffeedback}
\alias{cdffeedback}
\title{Feedback for the elicited distribution of the population CDF}
\usage{
cdffeedback(medianfit, precisionfit, quantiles = c(0.05, 0.95), vals = NA,
  alpha = 0.05, median.dist = "best", precision.dist = "gamma",
  n.rep = 10000)
}
\arguments{
\item{medianfit}{The output of a \link{fitdist} command following elicitation
of the expert's beliefs about the population median.}

\item{precisionfit}{The output of a \link{fitprecision} command following elicitation
of the expert's beliefs about the population precision.}

\item{quantiles}{A vector of quantiles \eqn{q_1, \ldots,q_n} required for feedback}

\item{vals}{A vector of population values \eqn{x_1,\ldots,x_n} required for feedback}

\item{alpha}{The size of the 100(1-alpha)\% credible interval}

\item{median.dist}{The fitted distribution for the population median. Can be one of \code{"normal"},
\code{"lognormal"} or \code{"best"}, where \code{"best"} will select the best fitting out of 
normal and lognormal.}

\item{precision.dist}{The fitted distribution for the population precision. Can either be \code{"gamma"}
or \code{"lognormal"}.}

\item{n.rep}{The number of randomly sampled CDFs used to estimated the median
and credible interval.}
}
\value{
Fitted median and 100(1-alpha)\% credible interval for population 
 quantiles and probabilities.
 
 \item{$quantiles}{Each row gives the fitted median 
 and 100(1-alpha)\% credible interval for each uncertain population quantile 
 specified in \code{quantiles}: the fitted median 
 and 100(1-alpha)\% credible interval for the value of \eqn{x_{q_i}} where 
 \eqn{P(X\le x_{q_i} | \mu, \sigma^2) = q_i.}} 
 \item{$probs}{Each row gives the fitted median 
 and 100(1-alpha)\% credible interval for each uncertain population probability 
 specified in \code{probs}: the fitted median 
 and 100(1-alpha)\% credible interval for the value of
 \eqn{P(X\le x_i | \mu, \sigma^2).} }
}
\description{
Report the median and 100(1-alpha)\% credible interval for point on the population CDF
}
\details{
Denote the uncertain population CDF by \deqn{P(X \le x | \mu, \sigma^2),}where \eqn{\mu}
is the uncertain population median and \eqn{\sigma^(-2)} is the uncertain population precision.
Feedback can be reported in the form of the median and 100(1-alpha)\% credible interval for
(a) an uncertain probability \eqn{P(X \le x | \mu, \sigma^2)}, where \eqn{x} is a specified 
population value and (b) an uncertain quantile \eqn{x_q} defined by \eqn{P(X \le x_q | \mu, \sigma^2) = q}, where \eqn{q} is a specified 
population probability.
}
\examples{
\dontrun{
prfit <- fitprecision(interval = c(60, 70), propvals = c(0.2, 0.4), trans = "log")
medianfit <- fitdist(vals = c(50, 60, 70), probs = c(0.05, 0.5,  0.95), lower = 0)
cdffeedback(medianfit, prfit, quantiles = c(0.01, 0.99),
            vals = c(65, 75), alpha = 0.05, n.rep = 10000)
 }  
}

