% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleFit.R
\name{sampleFit}
\alias{sampleFit}
\title{Sample from the elicited distributions}
\usage{
sampleFit(fit, n, expert = 1)
}
\arguments{
\item{fit}{An object of class elicitation}

\item{n}{The required sample size for each elicitation}

\item{expert}{Specify which expert's distributions to sample 
from, if multiple experts' judgements have been elicited.}
}
\value{
A matrix of sampled values, one column per distribution.
Column names are given to label the distributions.
}
\description{
Generates a random sample from all distributions specified
within an object of class \code{elicitation}
}
\examples{
\dontrun{
v <- c(20,30,50)
p <- c(0.25,0.5,0.75)
myfit <- fitdist(vals = v, probs = p, lower = 0, upper = 100)
sampleFit(myfit, n = 10)
}

}
