% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicitCopula.R
\name{copulaSample}
\alias{copulaSample}
\title{Generate correlated samples from elicited marginal distributions using a multivariate normal copula}
\usage{
copulaSample(..., cp, n, d = NULL, ex = 1)
}
\arguments{
\item{...}{A list of objects of class \code{elicitation}.
command, one per marginal distribution, separated by commas.}

\item{cp}{A matrix of pairwise concordance probabilities, with element i,j the elicited probability
P(X_i > m_i, X_j > m_j or X_i < m_i, X_j < m_j), where m_i and m_j are the elicited medians of the uncertain quantities X_i and X_j.
Only the upper triangular elements in the matrix need to be specified; the remaining elements can be set at 0.}

\item{n}{The sample size to be generated}

\item{d}{A vector of distributions to be used for each elicited quantity: a string with elements chosen from
\code{"normal", "t", "gamma", "lognormal", "logt", "beta", "mirrorgamma", "mirrorlognormal", "mirrorlogt"}. The default is to use
the best fitting distribution in each case.}

\item{ex}{If separate judgements have been elicited from multiple experts and stored
in the \code{elicitation} objects, use this argument to select a single expert's judgements
for sampling. Note that this function will not simultaneously generate samples for all experts.}
}
\value{
A matrix of sampled values, one row per sample.
}
\description{
Takes elicited marginal distributions and elicited concordance probabilities: pairwise
probabilities of two uncertain quantities being greater than their medians, and generates
a correlated sample, assuming the elicited marginal distributions and a multivariate
normal copula
}
\examples{
\dontrun{
p1 <- c(0.25, 0.5, 0.75)
v1 <- c(0.5, 0.55, 0.6)
v2 <- c(0.22, 0.3, 0.35)
v3 <- c(0.11, 0.15, 0.2)
myfit1 <- fitdist(v1, p1, 0, 1)
myfit2 <- fitdist(v2, p1, 0, 1)
myfit3 <- fitdist(v3, p1, 0, 1)
quad.probs <- matrix(0, 3, 3)
quad.probs[1, 2] <- 0.4
quad.probs[1, 3] <- 0.4
quad.probs[2, 3] <- 0.3
copulaSample(myfit1, myfit2, myfit3, cp=quad.probs, n=100, d=NULL)
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
