% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SESraster.R
\name{plot_alg_metrics}
\alias{plot_alg_metrics}
\title{Plot performance of randomization algorithms}
\usage{
plot_alg_metrics(x, what = "spp", ...)
}
\arguments{
\item{x}{list. Object returned by \code{\link{algorithm_metrics}}}

\item{what}{What should be plotted, "species" or "site" metrics?}

\item{...}{Additional parameters passed to \code{\link[terra]{plot}}}
}
\description{
Plots objects returned by \code{\link{algorithm_metrics}}
}
\examples{
library(SESraster)
library(terra)
r <- load_ext_data()
am1 <- algorithm_metrics(r, spat_alg = "bootspat_naive", spat_alg_args=list(random="species"))
am2 <- algorithm_metrics(r, spat_alg = "bootspat_naive", spat_alg_args=list(random="site"))
plot_alg_metrics(am1)
plot_alg_metrics(am2)
plot_alg_metrics(am1, "site")

}
\seealso{
\code{\link{algorithm_metrics}}
}
\author{
Neander M. Heming
}
