% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keggInteractome.R
\docType{data}
\name{kegg}
\alias{kegg}
\title{KEGG interactome}
\format{
"kegg" is an igraph network object of 5934 nodes and 77158 edges 
corresponding to the union of 306 KEGG pathways.
}
\source{
\url{https://www.genome.jp/kegg/}
}
\usage{
kegg
}
\description{
Interactome generated by merging KEGG pathways 
extracted using the \code{graphite} R package (update: April, 2020).
}
\examples{

\donttest{
library(igraph)

# KEGG graph
summary(kegg)

# KEGG degrees of freedom
vcount(kegg)*(vcount(kegg) - 1)/2 - ecount(kegg)

# KEGG average shortest path length
mean_distance(kegg)

}

}
\references{
Kanehisa M, Goto S (1999). KEGG: kyoto encyclopedia of genes and genomes. 
Nucleic Acid Research 28(1): 27-30. 
<https://doi.org/10.1093/nar/27.1.29>

Martini P, Sales G, Massa MS, Chiogna M, Romualdi C. Along signal paths: 
anempirical gene set approach exploiting pathway topology. 
Nucleic Acids Res. 41(1):e19.
<https://doi.org/10.1093/nar/gks866>
}
