% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMml.R
\name{predict.ML}
\alias{predict.ML}
\title{SEM-based out-of-sample prediction using node-wise ML}
\usage{
\method{predict}{ML}(object, newdata, verbose = FALSE, ...)
}
\arguments{
\item{object}{A model fitting object from \code{SEMml()} function.}

\item{newdata}{A matrix containing new data with rows corresponding to
subjects, and columns to variables.}

\item{verbose}{Print predicted out-of-sample MSE values (default = FALSE).}

\item{...}{Currently ignored.}
}
\value{
A list of 2 objects:
\enumerate{
\item "PE", vector of the prediction error equal to the Mean Squared Error
(MSE) for each out-of-bag prediction. The first value of PE is the AMSE,
where we average over all (sink and mediators) graph nodes.
\item "Yhat", the matrix of continuous predicted values of graph nodes  
(excluding source nodes) based on out-of-bag samples. 
}
}
\description{
Predict method for ML objects.
}
\examples{

\donttest{
# Load Amyotrophic Lateral Sclerosis (ALS)
data<- alsData$exprs; dim(data)
data<- transformData(data)$data
ig<- alsData$graph; gplot(ig)

#...with train-test (0.5-0.5) samples
set.seed(123)
train<- sample(1:nrow(data), 0.5*nrow(data))

start<- Sys.time()
# ... rf
res1<- SEMml(ig, data, train, algo="rf", vimp=FALSE)
mse1<- predict(res1, data[-train, ], verbose=TRUE)

# ... xgb
res2<- SEMml(ig, data, train, algo="xgb", vimp=FALSE)
mse2<- predict(res2, data[-train, ], verbose=TRUE)

# ... nn
res3<- SEMml(ig, data, train, algo="nn", vimp=FALSE)
mse3<- predict(res3, data[-train, ], verbose=TRUE)

# ... gam
res4<- SEMml(ig, data, train, algo="gam", vimp=FALSE)
mse4<- predict(res4, data[-train, ], verbose=TRUE)

# ... sem
res5<- SEMml(ig, data, train, algo="sem", vimp=FALSE)
mse5<- predict(res5, data[-train, ], verbose=TRUE)
end<- Sys.time()
print(end-start)
}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
