#' Data Definitions for \code{data_supply}
#'
#' This dataset contains wind and solar energy production using the installed capacities
#' of 2017 considered as a baseline power scenario.
#' The dataset can be found at https://researchdata.reading.ac.uk/321/, and users are referred to
#' Bloomfield et al. (2021) for further details.
#'
#' @docType data
#'
#' @usage data(data_supply)
#'
#' @format An object of class \code{"data.frame"}
#'
#' @keywords datasets
#'
#' @references Bloomfield, Hannah and Brayshaw, David (2021): ERA5 derived time series of European aggregated surface weather variables,
#' wind power, and solar power capacity factors: hourly data from 1950-2020. \doi{10.17864/1947.000321}
#'
#' @source  University of Reading. Dataset.  \doi{10.17864/1947.000321}
#'
#' @examples
#' data("data_supply")
"data_supply"



#' Data Definitions for \code{data_ic2017}
#'
#' A data frame containing installed wind and solar power capacities for the 27 countries included in data_supply.
#'
#' @docType data
#'
#' @usage data(data_ic2017)
#'
#' @format An object of class \code{"data.frame"}
#'
#' @examples
#' data(data_ic2017)
"data_ic2017"
