#' Follow-Up Study of Nonrespondents from Gnap (1995)
#' 
#' Follow-up study of nonrespondents from the Gnap (1995) study on the
#' workload of elementary school teachers in Maricopa County, Arizona.
#' @name teachnr
#' @docType data
#' @format data frame with the following 6 variables:
#' \describe{
#'   \item{hrwork}{number of hours required to work at school per week}
#'   \item{size}{class size}
#'   \item{preprmin}{minutes spent per week in school on preparation}
#'   \item{assist}{minutes per week that a teacher's aide works with
#'     the teacher in the classroom}
#' }
#' @note The study is described in Exercise 16 of Chapter 15. The 
#' actual date are given in \code{\link{teachers}}. Cluster size data for
#' the original study are given in \code{\link{teachmi}}.
#' @source Data courtesy of Rita Gnap (1995).
#' @references Gnap, R. (1995). Teacher load in Arizona elementary school 
#' districts in Maricopa County. Ph.D. diss., Arizona State University 
#' 
#' Lohr (1999). Sampling: Design and Analysis, Duxbury, p. TODO and
#'   446.
#' @export
roxygen()
