% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCor.R
\name{plotCor}
\alias{plotCor}
\title{Plot Correlation}
\usage{
plotCor(bg, method = "spearman", cor_th = NULL)
}
\arguments{
\item{bg}{\linkS4class{SWD} object used to compute the correlation matrix.}

\item{method}{character. The method used to compute the correlation matrix,
default is "spearman".}

\item{cor_th}{numeric. If provided it prints only the coefficients that are
higher or lower than the given threshold, default is \code{NULL}.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Plot a correlation matrix heat map with the value of the correlation
coefficients according with the given method. If cor_th is passed then it
prints only the coefficients that are higher or lower than the given
threshold.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 10000)

# Create SWD object
bg <- prepareSWD(species = "Virtual species", a = bg_coords,
                 env = predictors, categorical = "biome")

# Plot heat map
plotCor(bg, method = "spearman")

# Plot heat map showing only values higher than given threshold
plotCor(bg, method = "spearman", cor_th = 0.8)
}
}
\author{
Sergio Vignali
}
