% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubsample.R
\name{getSubsample}
\alias{getSubsample}
\title{Get Dataset Subsample, Deprecated}
\usage{
getSubsample(dataset, size, seed = NULL)
}
\arguments{
\item{dataset}{\linkS4class{SWD} object.}

\item{size}{numeric. The size of the sub sample.}

\item{seed}{numeric. The value used to set the seed in order to have
consistent results, default is \code{NULL}.}
}
\value{
The sub sample as \linkS4class{SWD} object.
}
\description{
Get a random subsample of an \linkS4class{SWD} object. This function is
deprecated, don't use it with the an \code{\link{SWD}} object that contains
presence and absence/background locations together.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
bg <- prepareSWD(species = "Virtual species", a = bg_coords, env = predictors,
                 categorical = "biome")

# Get a subsample
getSubsample(bg, size = 2000, seed = 25)
}
\author{
Sergio Vignali
}
